/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.report.urgentpath;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import cz.insophy.inplan.mrp.CustomerRequest;
import cz.insophy.inplan.mrp.SupplyRequest;
import cz.insophy.inplan.report.urgentpath.GarPathNode;
import cz.insophy.inplan.report.urgentpath.InitialWaitingAnalyzer;
import cz.insophy.inplan.report.urgentpath.PathNode;
import cz.insophy.inplan.report.urgentpath.SaPathNode;
import cz.insophy.inplan.report.urgentpath.SrPathNode;
import cz.insophy.inplan.report.urgentpath.UrgentPathInfoBuilder;
import cz.insophy.inplan.report.urgentpath.UrgentPathVisitor;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.store.MaterialQuotas;
import cz.insophy.inplan.store.StoreActivity;
import cz.insophy.inplan.store.StoreSchedule;
import cz.insophy.inplan.store.StoreType;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.superplan.ProductionTreeAlgorithms;
import cz.insophy.inplan.util.TimeSpan;
import cz.insophy.inplan.util.Tuple;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum InitialWaitingAnalyzers implements InitialWaitingAnalyzer
{
    ORIGINAL{

        @Override
        public void initialWaiting(@Nonnull PathNode firstNode, @Nullable GarPathNode firstGar, @Nonnull CustomerRequest cr, UrgentPathInfoBuilder builder) {
            Long authDate;
            long matTime;
            Material mat;
            GeneralizedActionRequest gar;
            if (firstNode == firstGar) {
                GeneralizedActionRequest gar2 = Preconditions.checkNotNull(firstGar).getGar();
                builder.analyzeGarWaiting(gar2, builder.getSuperplan().getFixationDate(), gar2.getStartDate(), false);
                return;
            }
            GeneralizedActionRequest generalizedActionRequest = gar = firstGar == null ? null : firstGar.getGar();
            if (gar != null) {
                long authRdTime = builder.getAuthRdTime(ProductionTreeAlgorithms.getNearestGor(gar));
                builder.analyzeGarWaiting(gar, builder.getSuperplan().getFixationDate(), authRdTime, false);
            }
            final SaPathNode[] firstSaW = new SaPathNode[1];
            final SrPathNode[] firstSrW = new SrPathNode[1];
            firstNode.accept(new UrgentPathVisitor(){

                @Override
                public void visit(SrPathNode pathNode) {
                    firstSrW[0] = pathNode;
                }

                @Override
                public void visit(SaPathNode pathNode) {
                    firstSaW[0] = pathNode;
                }

                @Override
                public void visit(GarPathNode pathNode) {
                }
            });
            SupplyRequest firstSr = null;
            if (firstSrW[0] != null) {
                firstSr = firstSrW[0].getSr();
            }
            StoreActivity firstSa = null;
            if (firstSaW[0] != null) {
                firstSa = firstSaW[0].getSa();
            }
            if (firstSa != null) {
                mat = firstSa.getMaterial();
                matTime = firstSa.getStart();
                if (GeneralizedRequest.isDateValid(mat.getMaterialHorizon())) {
                    matTime = Math.min(matTime, builder.getSuperplan().getFixationDate() + mat.getMaterialHorizon());
                }
            } else if (firstSr != null) {
                mat = firstSr.getMaterial();
                matTime = firstSr.getTime();
                if (GeneralizedRequest.isDateValid(mat.getMaterialHorizon())) {
                    matTime = Math.min(matTime, builder.getSuperplan().getFixationDate() + mat.getMaterialHorizon());
                }
            } else {
                return;
            }
            if (matTime <= (authDate = gar == null ? Long.valueOf(builder.getSuperplan().getFixationDate()) : Long.valueOf(builder.getAuthRdTime(ProductionTreeAlgorithms.getNearestGor(gar)))) && gar != null) {
                long logTime = gar.getAction().getMinTimeToPrepare();
                builder.analyzeGarWaiting(gar, Math.max(authDate, matTime + logTime), gar.getStartDate(), false);
                if (authDate < matTime + logTime) {
                    builder.getLogisticTimes().put(gar, matTime + logTime - authDate);
                }
                return;
            }
            Preconditions.checkNotNull(authDate, "First GAR in urgent path must be authorized.");
            StoreSchedule storeSchedule = builder.getSuperplan().getPlan().getStoreSchedule(StoreType.ACTUAL_ESTIMATE_VIEW);
            long lastTime = authDate;
            double neededQty = gar == null ? cr.getQty() : gar.getAction().getBom().getQty(mat) * gar.getInPlanQty();
            boolean isMissing = storeSchedule.getQ(mat, authDate, true) + 1.0E-7 <= neededQty;
            for (StoreActivity sa : storeSchedule.getActivities(mat)) {
                if (sa.getTime() <= authDate) continue;
                long time = sa.getTime();
                long cappedTime = Math.min(time, matTime);
                double q = storeSchedule.getQ(mat, cappedTime, true);
                if (isMissing) {
                    List<TimeSpan> lts;
                    Tuple<Double, List<TimeSpan>> waitingTuple = builder.getMaterialWaitings().get(mat);
                    List<TimeSpan> list = lts = waitingTuple == null ? null : waitingTuple.getSecond();
                    if (waitingTuple == null || lts == null || lts.isEmpty()) {
                        builder.getMaterialWaitings().put(mat, Tuple.create(neededQty, Lists.newArrayList(TimeSpan.fromStartEnd(lastTime, cappedTime))));
                    } else {
                        lts.add(TimeSpan.fromStartEnd(lastTime, cappedTime));
                    }
                } else if (gar != null) {
                    builder.analyzeGarWaiting(gar, lastTime, cappedTime, false);
                }
                lastTime = cappedTime;
                boolean bl = isMissing = neededQty > q + 1.0E-7 && matTime > time;
                if (matTime > time) continue;
                break;
            }
            if (gar != null) {
                long logTime = gar.getAction().getMinTimeToPrepare();
                if (logTime >= gar.getStartDate() - lastTime) {
                    builder.getLogisticTimes().put(gar, gar.getStartDate() - lastTime);
                } else {
                    builder.getLogisticTimes().put(gar, logTime);
                    builder.analyzeGarWaiting(gar, lastTime + logTime, gar.getStartDate(), false);
                }
            }
        }
    }
    ,
    QUOTA{

        @Override
        public void initialWaiting(@Nonnull PathNode firstNode, @Nullable GarPathNode firstGar, @Nonnull CustomerRequest cr, UrgentPathInfoBuilder builder) {
            Long authDate;
            long matTime;
            Material mat;
            GeneralizedActionRequest gar;
            if (firstNode == firstGar) {
                GeneralizedActionRequest gar2 = Preconditions.checkNotNull(firstGar).getGar();
                builder.analyzeGarWaiting(gar2, builder.getSuperplan().getFixationDate(), gar2.getStartDate(), false);
                return;
            }
            GeneralizedActionRequest generalizedActionRequest = gar = firstGar == null ? null : firstGar.getGar();
            if (gar != null) {
                long authRdTime = builder.getAuthRdTime(ProductionTreeAlgorithms.getNearestGor(gar));
                builder.analyzeGarWaiting(gar, builder.getSuperplan().getFixationDate(), authRdTime, false);
            }
            final SaPathNode[] firstSaW = new SaPathNode[1];
            final SrPathNode[] firstSrW = new SrPathNode[1];
            firstNode.accept(new UrgentPathVisitor(){

                @Override
                public void visit(SrPathNode pathNode) {
                    firstSrW[0] = pathNode;
                }

                @Override
                public void visit(SaPathNode pathNode) {
                    firstSaW[0] = pathNode;
                }

                @Override
                public void visit(GarPathNode pathNode) {
                }
            });
            SupplyRequest firstSr = null;
            if (firstSrW[0] != null) {
                firstSr = firstSrW[0].getSr();
            }
            StoreActivity firstSa = null;
            if (firstSaW[0] != null) {
                firstSa = firstSaW[0].getSa();
            }
            if (firstSa != null) {
                mat = firstSa.getMaterial();
                matTime = firstSa.getStart();
                if (GeneralizedRequest.isDateValid(mat.getMaterialHorizon())) {
                    matTime = Math.min(matTime, builder.getSuperplan().getFixationDate() + mat.getMaterialHorizon());
                }
            } else if (firstSr != null) {
                mat = firstSr.getMaterial();
                matTime = firstSr.getTime();
                if (GeneralizedRequest.isDateValid(mat.getMaterialHorizon())) {
                    matTime = Math.min(matTime, builder.getSuperplan().getFixationDate() + mat.getMaterialHorizon());
                }
            } else {
                return;
            }
            if (matTime <= (authDate = gar == null ? Long.valueOf(builder.getSuperplan().getFixationDate()) : Long.valueOf(builder.getAuthRdTime(ProductionTreeAlgorithms.getNearestGor(gar))))) {
                if (gar != null) {
                    long logTime = gar.getAction().getMinTimeToPrepare();
                    builder.analyzeGarWaiting(gar, Math.max(authDate, matTime + logTime), gar.getStartDate(), false);
                    if (authDate < matTime + logTime) {
                        builder.getLogisticTimes().put(gar, matTime + logTime - authDate);
                    }
                }
                return;
            }
            Preconditions.checkNotNull(authDate, "First GAR in urgent path must be authorized.");
            StoreSchedule storeSchedule = builder.getSuperplan().getPlan().getStoreSchedule(StoreType.ACTUAL_ESTIMATE_VIEW);
            final long finalMatTime = matTime;
            MaterialQuotas forwardQuotas = storeSchedule.getInitialForwardQuotas(Collections.singleton(mat), authDate, new Predicate<StoreActivity>(){

                @Override
                public boolean apply(@Nullable StoreActivity input) {
                    return input.getTime() < finalMatTime;
                }
            });
            double neededQty = gar == null ? cr.getQty() : gar.getAction().getBom().getQty(mat) * gar.getInPlanQty();
            Long materialAvailableTime = forwardQuotas.getMaterialAvailableTime(mat, neededQty);
            if (materialAvailableTime == null) {
                materialAvailableTime = matTime;
            }
            builder.getMaterialWaitings().put(mat, Tuple.create(neededQty, Lists.newArrayList(TimeSpan.fromStartEnd(authDate, materialAvailableTime))));
            if (gar != null) {
                long logTime = gar.getAction().getMinTimeToPrepare();
                if (logTime >= gar.getStartDate() - matTime) {
                    builder.getLogisticTimes().put(gar, gar.getStartDate() - matTime);
                } else {
                    builder.getLogisticTimes().put(gar, logTime);
                    builder.analyzeGarWaiting(gar, matTime + logTime, gar.getStartDate(), false);
                }
            }
        }
    };

}

